import javax.swing.SwingUtilities;

import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import client.Presenter;

public class MainJavaApplication implements Runnable {

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new MainJavaApplication());
	}

	@Override
	public void run() {
		AbstractApplicationContext applicationContext = new ClassPathXmlApplicationContext(
				new String[] { "main-context.xml", "additional-context.xml" });
		Presenter presenter =
			(Presenter) applicationContext.getBean("presenter");
		presenter.displayViewOnScreen();
	}
}
